------------------------------------------------------------------------------
--					Jagged Alliance 3D Campaign Main Script					--
------------------------------------------------------------------------------
--    ,       - 
--      
--    -    -  think
--
--
CAMPAIGN_NAME = "JAZZ"	--  
--
--
include("campaigns/"..CAMPAIGN_NAME.."/settings")			-- 
include("campaigns/"..CAMPAIGN_NAME.."/dev_settings")		-- 
--------------------------------------------------------------------------------
-- data
--------------------------------------------------------------------------------
include("campaigns/"..CAMPAIGN_NAME.."/enums")				-- 
include("campaigns/"..CAMPAIGN_NAME.."/global_vars")		--   
include("campaigns/"..CAMPAIGN_NAME.."/vars")				-- 
include("campaigns/"..CAMPAIGN_NAME.."/emails")			-- emails
include("campaigns/"..CAMPAIGN_NAME.."/sectors")			-- sectors
include("campaigns/"..CAMPAIGN_NAME.."/mercs")				-- mercs
include("campaigns/"..CAMPAIGN_NAME.."/forces")			--   
include("campaigns/"..CAMPAIGN_NAME.."/spawns")			--   
include("campaigns/"..CAMPAIGN_NAME.."/upgrades")			--  
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/common_triggers")
--------------------------------------------------------------------------------
-- tools
--------------------------------------------------------------------------------
include("campaigns/"..CAMPAIGN_NAME.."/proxy")				--   
include("campaigns/"..CAMPAIGN_NAME.."/ctools")			--    
include("campaigns/"..CAMPAIGN_NAME.."/emo")				-- EMO-2000 system
include("campaigns/"..CAMPAIGN_NAME.."/rpg_functions")		-- RPG-3000 system
include("campaigns/"..CAMPAIGN_NAME.."/relations")			--   
include("campaigns/"..CAMPAIGN_NAME.."/storyline")			--   
include("campaigns/"..CAMPAIGN_NAME.."/plot")			--   
include("campaigns/"..CAMPAIGN_NAME.."/auto_battle")		-- 
include("campaigns/"..CAMPAIGN_NAME.."/strategy")			-- strategy
include("campaigns/"..CAMPAIGN_NAME.."/economy")			-- economy
include("campaigns/"..CAMPAIGN_NAME.."/path_finding")		-- path finder
include("campaigns/"..CAMPAIGN_NAME.."/morale")			-- morale system
include("campaigns/"..CAMPAIGN_NAME.."/hospital")			-- healing system
include("campaigns/"..CAMPAIGN_NAME.."/training_facility")	-- JEDI-5000 system
include("campaigns/"..CAMPAIGN_NAME.."/email_server")	-- Email system
--------------------------------------------------------------------------------
-- events
--------------------------------------------------------------------------------
include("campaigns/"..CAMPAIGN_NAME.."/init_campaign")		--   " "
include("campaigns/"..CAMPAIGN_NAME.."/stop_campaign")		--   " "
include("campaigns/"..CAMPAIGN_NAME.."/start_mission")		--   " "
include("campaigns/"..CAMPAIGN_NAME.."/stop_mission")		--   " "
include("campaigns/"..CAMPAIGN_NAME.."/read_email")		--   " "
include("campaigns/"..CAMPAIGN_NAME.."/visit_site")		--   " "
include("campaigns/"..CAMPAIGN_NAME.."/hire")				--   ""
include("campaigns/"..CAMPAIGN_NAME.."/dismiss")			--   ""
include("campaigns/"..CAMPAIGN_NAME.."/on_spawn")			--  "    "
include("campaigns/"..CAMPAIGN_NAME.."/mission_select")	--  "    " -             
include("campaigns/"..CAMPAIGN_NAME.."/army_arrived")		--  "     3"
include("campaigns/"..CAMPAIGN_NAME.."/position_changed")	--  "  "
include("campaigns/"..CAMPAIGN_NAME.."/destination_changed")	--  "   "
include("campaigns/"..CAMPAIGN_NAME.."/relations_check")	--  " "
------------------------------------------------------------------------------
--   ()
------------------------------------------------------------------------------
initSectors()
------------------------------------------------------------------------------
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/safari")			--  ,   
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/north_road")		--   , 
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/dam")				--  
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/trainstation")		--  
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/airport")			--  
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/mines")				--  
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/port")				--  
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/coastal_fortress")	--  coastal_fortress
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/base")				--  base
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/north_base")		--  north_base
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/coastal_city")		--  coastal_city
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/palace")			--  palace
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/road_to_airport")	--  road_to_airport
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/crossroads")		--  crossroads
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/roadblock")			--  
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/mountain_village")	--   
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/outpost")			--  
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/pirate_island")		-- pirate_island
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/south_village")		-- south_village
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/detour_road")		-- detour_road
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/drug_deal")			-- drug_deal
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/stream")			-- stream
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/un_camp")			-- un_camp
------------------------------------------------------------------------------
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/test_level")		--  
------------------------------------------------------------------------------
-- campaign
------------------------------------------------------------------------------

function print(sUnit)
	log("_"..sUnit,"isUnitInBlackZone: ",service.isUnitInBlackZone(sUnit))
	log("_"..sUnit,"team: ",team(sUnit))
	log("_"..sUnit,"wounded: ",wounded(sUnit))
	log("_"..sUnit,"grenadeMaxDistance: ",grenadeMaxDistance(sUnit))
	log("_"..sUnit,"disappeared: ",disappeared(sUnit))
	log("_"..sUnit,"getPosition: ",getPosition(sUnit))
	log("_"..sUnit,"getPersonOrientation: ",getPersonOrientation(sUnit))
	log("_"..sUnit,"getPersonPose: ",getPersonPose(sUnit))
	log("_"..sUnit,"getHandIndex: ",getHandIndex(sUnit))
	log("_"..sUnit,"isAlive: ",isAlive(sUnit))
	log("_"..sUnit,"getMelee(false): ",getMelee(sUnit,false))
	log("_"..sUnit,"getGrenade: ",getGrenade(sUnit,"grenade"))
	log("_"..sUnit,"getGun: ",getGun(sUnit,-1))
	log("_"..sUnit,"canReloadWeapon(primary): ",canReloadWeapon(sUnit,getHandIndex(sUnit),"primary"))
	log("_"..sUnit,"getGunCapacity: ",getGunCapacity(sUnit,getHandIndex(sUnit)))
	log("_"..sUnit,"getNumBulletsInGun(primary): ",getNumBulletsInGun(sUnit,getHandIndex(sUnit),"primary"))
	log("_"..sUnit,"canShootBy(primary): ",canShootBy(sUnit,getHandIndex(sUnit),"primary"))
	log("_"..sUnit,"hasGrenade(grenade): ",hasGrenade(sUnit,"grenade"))
	log("_"..sUnit,"hasGun(a): ",hasGun(sUnit,"a","primary"), type(hasGun(sUnit,"a","primary")))
	log("_"..sUnit,"firingMode: ",firingMode(sUnit))

	log("_"..sUnit,"DURABILITYMAX    :",getPersonParameter(sUnit,"DURABILITYMAX"))
	log("_"..sUnit,"HEALTH           :",getPersonParameter(sUnit,"HEALTH"))
	log("_"..sUnit,"LEVEL            :",getPersonParameter(sUnit,"LEVEL"))
	log("_"..sUnit,"STRENGTH         :",getPersonParameter(sUnit,"STRENGTH"))         
	log("_"..sUnit,"DEXTERITY        :",getPersonParameter(sUnit,"DEXTERITY"))      
	log("_"..sUnit,"AGILITY          :",getPersonParameter(sUnit,"AGILITY"))
	log("_"..sUnit,"WISDOM           :",getPersonParameter(sUnit,"WISDOM"))       
	log("_"..sUnit,"LEADERSHIP       :",getPersonParameter(sUnit,"LEADERSHIP"))
	log("_"..sUnit,"MARKSMANSHIP     :",getPersonParameter(sUnit,"MARKSMANSHIP"))
	log("_"..sUnit,"MECHANICAL       :",getPersonParameter(sUnit,"MECHANICAL"))
	log("_"..sUnit,"MEDICAL          :",getPersonParameter(sUnit,"MEDICAL"))
	log("_"..sUnit,"EXPLOSIVES       :",getPersonParameter(sUnit,"EXPLOSIVES"))
	log("_"..sUnit,"BREATH           :",getPersonParameter(sUnit,"BREATH"))
	log("_"..sUnit,"BREATH_MAX       :",getPersonParameter(sUnit,"BREATH_MAX"))
	log("_"..sUnit,"BANDAGED         :",getPersonParameter(sUnit,"BANDAGED"))
	log("_"..sUnit,"NEUTRALKILLED    :",getPersonParameter(sUnit,"NEUTRALKILLED"))
	log("_"..sUnit,"ENEMYKILLED      :",getPersonParameter(sUnit,"ENEMYKILLED"))
	log("_"..sUnit,"ALLYKILLED       :",getPersonParameter(sUnit,"ALLYKILLED"))   
	log("_"..sUnit,"EXPERIENCE       :",getPersonParameter(sUnit,"EXPERIENCE"))       
	log("_"..sUnit,"CAMOUFLAGE       :",getPersonParameter(sUnit,"CAMOUFLAGE"))
	log("_"..sUnit,"HEARING          :",getPersonParameter(sUnit,"HEARING"))
	log("_"..sUnit,"MORALE           :",getPersonParameter(sUnit,"MORALE"))
	log("_"..sUnit,"SIGHTANGLE       :",getPersonParameter(sUnit,"SIGHTANGLE"))
	log("_"..sUnit,"SIGHTSHARP       :",getPersonParameter(sUnit,"SIGHTSHARP"))
	log("_"..sUnit,"AP               :",getPersonParameter(sUnit,"AP"))          
	log("_"..sUnit,"STUNNEDSIGHT     :",getPersonParameter(sUnit,"STUNNEDSIGHT"))
	log("_"..sUnit,"STUNNEDHEARING   :",getPersonParameter(sUnit,"STUNNEDHEARING"))  
	log("_"..sUnit,"DEPOSIT          :",getPersonParameter(sUnit,"DEPOSIT"))
	log("_"..sUnit,"SALARY           :",getPersonParameter(sUnit,"SALARY"))       

	log("_"..sUnit,"SPECIALIZATION   :",getPersonParameterStr(sUnit,"SPECIALIZATION"))
	log("_"..sUnit,"DAILOG           :",getPersonParameterStr(sUnit,"DAILOG"))
	log("_"..sUnit,"LASTTARGET       :",getPersonParameterStr(sUnit,"LASTTARGET"))      
        log("_"..sUnit,"STATUS           :",getPersonParameterStr(sUnit,"STATUS"))        
        log("_"..sUnit,"TEAM             :",getPersonParameterStr(sUnit,"TEAM"))
	log("_"..sUnit,"RACIST           :",getPersonParameterStr(sUnit,"RACIST"))
	log("_"..sUnit,"SEXIST           :",getPersonParameterStr(sUnit,"SEXIST"))
	log("_"..sUnit,"SEX              :",getPersonParameterStr(sUnit,"SEX"))
	log("_"..sUnit,"NATIONALITY      :",getPersonParameterStr(sUnit,"NATIONALITY"))
	log("_"..sUnit,"HATED_NATIONALITY:",getPersonParameterStr(sUnit,"HATED_NATIONALITY"))
	log("_"..sUnit,"RACE             :",getPersonParameterStr(sUnit,"RACE"))
	log("_"..sUnit,"ATTITUDE         :",getPersonParameterStr(sUnit,"ATTITUDE"))
	log("_"..sUnit,"SKILL1           :",getPersonParameterStr(sUnit,"SKILL1"))
	log("_"..sUnit,"SKILL2           :",getPersonParameterStr(sUnit,"SKILL2"))
	log("_"..sUnit,"PHOBIA           :",getPersonParameterStr(sUnit,"PHOBIA"))
	log("_"..sUnit,"TYPE             :",getPersonParameterStr(sUnit,"TYPE"))

	log("_"..sUnit,"takeAP: ",takeAP(sUnit))

	local enemiesList = {}
	local collectVisibleEnemies = function(index, human)
			if(	IsAlive(human.id) and
				(relations(team(sUnit),team(human.id))==ENEMY) and
				canOneSeeOther(sUnit,human.id)) then
				table.insert(enemiesList,human.id)
		        end
		end
	table.foreach(Humans, collectVisibleEnemies)
	local printTargetInfo = function(id)
			log("_"..sUnit,"*** I see ",id)
			local tx, ty, tz, tf = getPosition(id)
			log("_"..sUnit,"At position     : ",tx, ty, tz, tf)
			local nDist = service.person2person_distance(sUnit, id)
			log("_"..sUnit,"Distance        : ",nDist)
			log("_"..sUnit,"In range        : ",isDefWeaponRanged(sUnit,nDist))
			log("_"..sUnit,"Has obstacles   : ",isRayInterrupted(sUnit,tx,ty,tz,nDist))
			log("_"..sUnit,"isMyPantsBetter : ",isMyPantsBetter(sUnit,id))
			log("_"..sUnit,"isMyArmorBetter : ",isMyArmorBetter(sUnit,id))
			log("_"..sUnit,"isMyHelmetBetter: ",isMyHelmetBetter(sUnit,id))
			log("_"..sUnit,"findClipForMyGun: ",findClipForMyGun(sUnit,getHandIndex(sUnit),"primary",id))
			log("_"..sUnit,"findBetterGun   : ",findBetterGun(sUnit,id))
			log("_"..sUnit,"findBetterGun(s): ",findBetterGun(sUnit,sUnit))
		end
	local reportAboutVisibleEnemy = function(index, id)
			printTargetInfo(id)
		end
	log("_"..sUnit,"****** True  visible")	
	table.foreach(enemiesList, reportAboutVisibleEnemy)
	if(Humans[sUnit].visible_enemies) then
		local reportAboutSavedVisibleEnemy = function(name, visible)
			if((name~="size") and visible) then
				printTargetInfo(name)
			end
		end
		log("_"..sUnit,"****** Saved visible")	
		table.foreach(Humans[sUnit].visible_enemies, reportAboutSavedVisibleEnemy)
	end

end

function test(sector)
	log("test", "**** Start test ")

	local players = { getMissionPlayers(sector) }
	local checkPlayer = function(index, id)
		log("test", "**** Player ",id)
  
		local checkUnits = function(index, id)
			log("test", "**** unit ",id,IsAlive(id))
			print(id)
			end
		table.foreach(service.getPlayerUnits(id), checkUnits)
		end
	table.foreach(players, checkPlayer)
	log("test", "**** Finish test ")
	return(false);	
end

CampaignScript = 
{
	missionAlreadyStarted = false,

	--  
	onStartCampaign = function()
		G = {}
		return
	end,
	--   
	onFinanceTooltip = function()
		calcTooltip()
	end,
	--    
	canSwitchToRT = function()
		return checkTargetsList()
	end,
	--  .   
	onStopMission = function()
		log("campaign","*** onStopMission")
		eventStopMission()
		CampaignScript.missionAlreadyStarted = false
		return
	end,
	--  
	onStartMission = function(mission_name, persons_table, squad, cancel)
		eventStartMission(mission_name, persons_table, squad, cancel)
		return
	end,
	--   .      -
	onSpawn = function()
		eventSpawn()
		return
	end,
	--
	onArmyMarchFinished = function(player, mission)
		eventArmyArrived(player, mission)
		return
	end,
	--
	onStopCampaign = function()
		eventStopCampaign()
		return
	end,
	--
	onMissionSelect = function(mission_name, squad, path_only)
		return eventMissionSelect(mission_name, squad, path_only)
	end,
	--
	onEmailRead = function(email)
		eventEmailRead(email)
		return
	end,
	--
	onSiteVisit = function(site, page)
		eventSiteVisit(site, page)
		return
	end,
	--
	onHire = function(merc, withEquipment)
		return eventHire(merc, withEquipment)
	end,
	--
	onRelationsCheck = function(force1, force2)
		return eventRelationsCheck(force1, force2)	
	end,	
	--
	onDismissPerson = function(merc)
		eventDismiss(merc)
		return
	end,
	--
	onPositionChanged = function(squad, position)
		eventPositionChanged(squad, position)
		return
	end,	
	--
	onDestinationChanged = function(squad, destination)
		eventDestinationChanged(squad, destination)
		return
	end,
	--
	onUpgradeBuy = function(sector, upgrade)
		eventUpgradeBuy(sector, upgrade)		
		return
	end,
	--
	onUpgradeSell = function(sector, upgrade)
		eventUpgradeSell(sector, upgrade)
		return
	end,
	--
	isUpgradeAvailable = function(sector, upgrade)
		return eventIsUpgradeAvailable(sector, upgrade)
	end,
	--
	isUpgradeSellable = function(sector, upgrade)
		return Upgrades[upgrade].sellable
	end,	
	--
	isMercAvailable = function(merc)
		return Mercs[merc].available
	end,
	--
	isMercAlive = function(merc)
		return Mercs[merc].alive
	end,
	--
	onAutoBattleUpdate = function(sector, attacker, defender, a_num, d_num, fast)
		return eventOnAutoBattaleUpdate(sector, attacker, defender, a_num, d_num, fast)
	end,
	--
	onAutoBattleEnd = function(win_side, win_num)
		eventOnAutoBattleEnd(win_side, win_num)
		return
	end,
	--
	onMercKill = function(merc)
		log("morg", merc,"'s dead, baby. ", merc, "'s dead.")
		
		-- remembering merc's death
		Mercs[merc].alive = false
		
		local hired_num = 0
		local died_num = 0
		
		local countHiredDead = function(merc, data)
			-- how much ever hired mercs are dead
			if ( data.hired == true ) then
				hired_num = hired_num + 1
				
				if ( data.alive == false ) then
					died_num = died_num + 1
				else
					updateMorale(merc, MoralePenalty.BIG, "MERC DIED")
				end
			end
		end

		table.foreach(Mercs, countHiredDead)
		
		-- update death rate
		if ( hired_num ~= 0 ) then
			DEATH_RATE = 100 * died_num / hired_num
		elseif ( died_num == 0 ) then
			DEATH_RATE = 0
		else
			DEATH_RATE = 100
		end
		
		if ( service.checkPlayerUnits(PLAYER) == false ) then
			if ( CUR_MISSION.Finishing ~= true ) then
				if ( CUR_MISSION.Failed == true ) then
					if ( BATTLE_DATA.Enabled == true ) then
						if((Sectors[BATTLE_DATA.Sector].owner == CURRENT_ALLY) and (CURRENT_ALLY==CORP)) then
							if (FIRST_SECTOR_LOST == false) then
								FIRST_SECTOR_LOST = true
								sendMail("janus_02", nil, nil, false)
								--Emails["janus_02"].send(false)
								addEntry("j_02", false)
							end
						end
						Sectors[BATTLE_DATA.Sector].owner = BATTLE_DATA.Attacker
					end
					
					CUR_MISSION.KillTime = MISSION_TIME
					Triggers["end_trigger"].active = true
					
					CUR_MISSION.Finishing = true
				end
			end
			
			return
		end
		
		emo2000(merc, "dies")
	end,
	--
	onExitToMap = function(bool)
test(CUR_MISSION.Name)
		Sectors[CUR_MISSION.Name].onKill()
		local first_merc = CUR_MISSION.Mercs[1]
		local is_there_enemy = false;
		if (first_merc~= nil) then
			log("main", "ERROR onExitToMap CUR_MISSION.Mercs == {}")
			is_there_enemy = service.isThereEnemy(first_merc)
			if(isValid(BATTLE_DATA) and 
				BATTLE_DATA.Enabled and
				(not service.areThereDead())) then
				is_there_enemy = true	--    
			end	

		end
		--
		if ( (isGameInRT() == true) and (CAN_EXIT == true) and (is_there_enemy == false) ) then
			if ( CUR_MISSION.Finishing == false ) then
				if ( showMessageBox("are_you_sure_to_leave_sector", YES_NO, SMALL) == YES ) then
					if ( bool == true ) then
						local dead = service.areThereDead()
						if ( dead == true ) then
							if ( showMessageBox("do_you_want_loot", YES_NO, SMALL) == YES ) then
								takeLoot()
							end
						end
					end
					--
					if ( CUR_MISSION.Name == "north_road" ) then
						startDlg("pass_papers_script", CUR_MISSION.Mercs[1], CUR_MISSION.Mercs[1])
					end
					--

					local resetBreath = function(index, value)
						setPersonParameter(value,"BREATH",10000)
					end
					table.foreach(CUR_MISSION.Mercs, resetBreath)

					finishMission(true)
					CUR_MISSION.Finishing = true
				end
			end
		else
			showMessageBox("cant_exit_to_map", OK, SMALL)
		end
	end,
	--
	onImpHired = function(name)
		--
		log("onImpHired", " :", name)

		Mercs[name].hired = true

		IMP_CREATED = true

--		sendMail("ipa_01", nil, nil, false)

 		sendIPAAnswer(name)

		HEAL_PASSED[name] = -1
	
		setPersonParameter(name, "MORALE", 50)
	
		Mercs[name].salary = 0
	
		getHiredMercs(true)
		--
	end,
	--  ,     ,  if' 
	think = function()								
		local log_id = C_THINK_LOG

		sendIPAAnswer()

		--
		--TUTORIALS
		--
		if (TUTORIAL_GREET_SHOWN == false) then
			TUTORIAL_GREET_SHOWN = true
			playVideo("video/intro.bik")
		end
		
		local day = tonumber(getVariable("time_day"))
		local hour = tonumber(getVariable("time_hour"))
		local minute = tonumber(getVariable("time_minute"))
		local GameStage = tonumber(getVariable("GameStage"))
		local last_email = LAST_GET_MAIL_MINUTE + GET_MAIL_PERIOD
		--
		if ( NEED_AUTOBATTLE == true ) then
			NEED_AUTOBATTLE = false
			
			local mi = getMilitiaInfo(BATTLE_DATA.Sector)
			local force_size = BATTLE_DATA.AttackerSize
			
			log("need_ab", mi.num, force_size)
			
			if ( force_size > 0 ) then
				startAutoBattle(BATTLE_DATA.Sector, BATTLE_DATA.Attacker, Sectors[BATTLE_DATA.Sector].owner, force_size, mi.num)
			end
			
			resetBD()
		end
		--
		if ( last_email >= 60 ) then
			if ( (minute > 0)  and (minute < GET_MAIL_PERIOD) ) then
				last_email = last_email - 60
			end
		end
		--
--		if ( last_email < minute ) then
--			LAST_GET_MAIL_MINUTE = minute
			getMail()
--		end
		--
		-- hourly stuff
		--
		if ( LAST_TRAINING ~= hour ) then
			LAST_TRAINING = hour
			iWannaBeJedi()
		end
		--
		updatePlot()
		--daily stuff
		--
		if ( LAST_BALANCE_DAY < day ) then
			--
			processEconomy(day)
			--
			replenishPools()
			--
			mobilizationUpdate()
			--
			thinkStrategy()
			--
			setGameStage(GAME_STAGE)
			--
			log(log_id, "setting game stage to current value")
			--
		end
		--
		if ( GAME_STAGE ~= GameStage ) then
			log(log_id, "Internal GameStage", GameStage, "differs from external GAME_STAGE", GAME_STAGE)
			log(log_id, "Change thru console suspected!")
			log(log_id, "Applying internal GameStage to external GAME_STAGE")
			GAME_STAGE = GameStage
			initMercs(true)
			local m = Mercs
			local sent = false
			local sendNotify = function(merc, data)
				if ( (data.available == true) and (data.hasMessage > 0) and (data.hired == false) and (data.alive == true) and (data.agency == AGENCY) ) then
					if ( data.hasMessage > 1 ) then
						sendMail(merc.."_auto_reply_more", INBOX, UNREAD, true)
						sent = true
					else
						sendMail(merc.."_auto_reply", INBOX, UNREAD, true)
						sent = true
					end
					Mercs[merc].hasMessage = 0
				end
			end
			table.foreach(m, sendNotify)
			if ( sent == true ) then
				sendMessage(NEW_EMAIL, NEW_EMAIL)
			end
		end
		--	
		--updates
		--
		updateGVARS(false)
		updateSectors(false)
--		updateForces()
		--updatePlot()
		--
		--thinks
		--
		healMercs()
		--
		return
		--
	end,
	--
	isForceAllyToMercs = function(force)
		return ALLY == checkRelations(PLAYER, force)
	end
}
